-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Versione server:              10.4.34-MariaDB-log - mariadb.org binary distribution
-- S.O. server:                  Win64
-- HeidiSQL Versione:            12.11.0.7065
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Dump della struttura del database sampledb
CREATE DATABASE IF NOT EXISTS `sampledb` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci */;
USE `sampledb`;

-- Dump della struttura di tabella sampledb.charts
CREATE TABLE IF NOT EXISTS `charts` (
  `idchart` int(11) NOT NULL AUTO_INCREMENT,
  `chartkey` varchar(16) DEFAULT '' COMMENT 'Used to group values in a chart',
  `label` varchar(45) DEFAULT '',
  `value` double DEFAULT 0,
  `color` varchar(6) DEFAULT '',
  `note` varchar(255) DEFAULT '',
  PRIMARY KEY (`idchart`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Charts data';

-- Dump dei dati della tabella sampledb.charts: ~9 rows (circa)
INSERT INTO `charts` (`idchart`, `chartkey`, `label`, `value`, `color`, `note`) VALUES
	(1, 'ch01', 'gas', 100, '0099e6', ''),
	(2, 'ch01', 'electricity', 50, '1ab2ff', ''),
	(3, 'ch01', 'water', 25, '47C1FF', ''),
	(4, 'ch02', '2025', 10, '1e81b0', ''),
	(5, 'ch02', '2024', 10, 'e28743', ''),
	(6, 'ch02', '2023', 10, 'eab676', ''),
	(7, 'ch02', '2022', 10, '76b5c5', ''),
	(8, 'ch02', '2021', 10, '873e23', ''),
	(9, 'ch02', '2020', 10, '154c79', '');

-- Dump della struttura di tabella sampledb.customers
CREATE TABLE IF NOT EXISTS `customers` (
  `customerNumber` int(11) NOT NULL,
  `customerName` varchar(50) NOT NULL,
  `contactLastName` varchar(50) NOT NULL,
  `contactFirstName` varchar(50) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `addressLine1` varchar(50) NOT NULL,
  `addressLine2` varchar(50) DEFAULT NULL,
  `city` varchar(50) NOT NULL,
  `state` varchar(50) DEFAULT NULL,
  `postalCode` varchar(15) DEFAULT NULL,
  `country` varchar(50) NOT NULL,
  `salesRepEmployeeNumber` int(11) DEFAULT NULL,
  `creditLimit` double DEFAULT NULL,
  PRIMARY KEY (`customerNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Dump dei dati della tabella sampledb.customers: 122 rows
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` (`customerNumber`, `customerName`, `contactLastName`, `contactFirstName`, `phone`, `addressLine1`, `addressLine2`, `city`, `state`, `postalCode`, `country`, `salesRepEmployeeNumber`, `creditLimit`) VALUES
	(103, 'Atelier graphique', 'Schmitt', 'Carine ', '40.32.2555', '54, rue Royale', NULL, 'Nantes', NULL, '44000', 'France', 1370, 21000),
	(112, 'Signal Gift Stores', 'King', 'Jean', '7025551838', '8489 Strong St.', NULL, 'Las Vegas', 'NV', '83030', 'USA', 1166, 71800),
	(114, 'Australian Collectors, Co.', 'Ferguson', 'Peter', '03 9520 4555', '636 St Kilda Road', 'Level 3', 'Melbourne', 'Victoria', '3004', 'Australia', 1611, 117300),
	(119, 'La Rochelle Gifts', 'Labrune', 'Janine ', '40.67.8555', '67, rue des Cinquante Otages', NULL, 'Nantes', NULL, '44000', 'France', 1370, 118200),
	(121, 'Baane Mini Imports', 'Bergulfsen', 'Jonas ', '07-98 9555', 'Erling Skakkes gate 78', NULL, 'Stavern', NULL, '4110', 'Norway', 1504, 81700),
	(124, 'Mini Gifts Distributors Ltd.', 'Nelson', 'Susan', '4155551450', '5677 Strong St.', NULL, 'San Rafael', 'CA', '97562', 'USA', 1165, 210500),
	(125, 'Havel & Zbyszek Co', 'Piestrzeniewicz', 'Zbyszek ', '(26) 642-7555', 'ul. Filtrowa 68', NULL, 'Warszawa', NULL, '01-012', 'Poland', NULL, 0),
	(128, 'Blauer See Auto, Co.', 'Keitel', 'Roland', '+49 69 66 90 2555', 'Lyonerstr. 34', NULL, 'Frankfurt', NULL, '60528', 'Germany', 1504, 59700),
	(129, 'Mini Wheels Co.', 'Murphy', 'Julie', '6505555787', '5557 North Pendale Street', 'Void Space', 'San Francisco', 'CA', '94217', 'USA', 1165, 64600),
	(131, 'Land of Toys Inc.', 'Lee', 'Kwai', '2125557818', '897 Long Airport Avenue', '', 'NYC', 'NY', '10022', 'USA', 1165, 114900),
	(141, 'Euro+ Shopping Channel', 'Freyre', 'Diego ', '(91) 555 94 44', 'C/ Moralzarzal, 86', NULL, 'Madrid', NULL, '28034', 'Spain', 1370, 227600),
	(144, 'Volvo Model Replicas, Co', 'Berglund', 'Christina ', '0921-12 3555', 'Berguvsvägen  8', NULL, 'Luleå', NULL, 'S-958 22', 'Sweden', 1504, 53100),
	(145, 'Danish Wholesale Imports', 'Petersen', 'Jytte ', '31 12 3555', 'Vinbæltet 34', NULL, 'Kobenhavn', NULL, '1734', 'Denmark', 1401, 83400),
	(146, 'Saveley & Henriot, Co.', 'Saveley', 'Mary ', '78.32.5555', '2, rue du Commerce', NULL, 'Lyon', NULL, '69004', 'France', 1337, 123900),
	(148, 'Dragon Souveniers, Ltd.', 'Natividad', 'Eric', '+65 221 7555', 'Bronz Sok.', 'Bronz Apt. 3/6 Tesvikiye', 'Singapore', NULL, '079903', 'Singapore', 1621, 103800),
	(151, 'Muscle Machine Inc', 'Young', 'Jeff', '2125557413', '4092 Furth Circle', 'Suite 400', 'NYC', 'NY', '10022', 'USA', 1286, 138500),
	(157, 'Diecast Classics Inc.', 'Leong', 'Kelvin', '2155551555', '7586 Pompton St.', '', 'Allentown', 'PA', '70267', 'USA', 1216, 1000600),
	(161, 'Technics Stores Inc.', 'Hashimoto', 'Juri', '6505556809', '9408 Furth Circle', NULL, 'Burlingame', 'CA', '94217', 'USA', 1165, 84600),
	(166, 'Handji Gifts& Co', 'Victorino', 'Wendy', '+65 224 1555', '106 Linden Road Sandown', '2nd Floor', 'Singapore', NULL, '069045', 'Singapore', 1612, 97900),
	(167, 'Herkku Gifts', 'Oeztan', 'Veysel', '+47 2267 3215', 'Brehmen St. 121', 'PR 334 Sentrum', 'Bergen', NULL, 'N 5804', 'Norway  ', 1504, 96800),
	(168, 'American Souvenirs Inc', 'Franco', 'Keith', '2035557845', '149 Spinnaker Dr.', 'Suite 101', 'New Haven', 'CT', '97823', 'USA', 1286, 0),
	(169, 'Porto Imports Co.', 'de Castro', 'Isabel ', '(1) 356-5555', 'Estrada da saúde n. 58', NULL, 'Lisboa', NULL, '1756', 'Portugal', NULL, 0),
	(171, 'Daedalus Designs Imports', 'Rancé', 'Martine ', '20.16.1555', '184, chaussée de Tournai', NULL, 'Lille', NULL, '59000', 'France', 1370, 82900),
	(172, 'La Corne D\'abondance, Co.', 'Bertrand', 'Marie', '(1) 42.34.2555', '265, boulevard Charonne', NULL, 'Paris', NULL, '75012', 'France', 1337, 84300),
	(173, 'Cambridge Collectables Co.', 'Tseng', 'Jerry', '6175555555', '4658 Baden Av.', NULL, 'Cambridge', 'MA', '51247', 'USA', 1188, 43400),
	(175, 'Gift Depot Inc.', 'King', 'Julie', '2035552570', '25593 South Bay Ln.', NULL, 'Bridgewater', 'CT', '97562', 'USA', 1323, 84300),
	(177, 'Osaka Souveniers Co.', 'Kentary', 'Mory', '+81 06 6342 5555', '1-6-20 Dojima', NULL, 'Kita-ku', 'Osaka', ' 530-0003', 'Japan', 1621, 81200),
	(181, 'Vitachrome Inc.', 'Frick', 'Michael', '2125551500', '2678 Kingston Rd.', 'Suite 101', 'NYC', 'NY', '10022', 'USA', 1286, 76400),
	(186, 'Toys of Finland, Co.', 'Karttunen', 'Matti', '90-224 8555', 'Keskuskatu 45', NULL, 'Helsinki', NULL, '21240', 'Finland', 1501, 96500),
	(187, 'AV Stores, Co.', 'Ashworth', 'Rachel', '(171) 555-1555', 'Fauntleroy Circus', NULL, 'Manchester', NULL, 'EC2 5NT', 'UK', 1501, 136800),
	(189, 'Clover Collections, Co.', 'Cassidy', 'Dean', '+353 1862 1555', '25 Maiden Lane', 'Floor No. 4', 'Dublin', NULL, '2', 'Ireland', 1504, 69400),
	(198, 'Auto-Moto Classics Inc.', 'Taylor', 'Leslie', '6175558428', '16780 Pompton St.', '', 'Brickhaven', 'MA', '58339', 'USA', 1216, 232000),
	(201, 'UK Collectables, Ltd.', 'Devon', 'Elizabeth', '(171) 555-2282', '12, Berkeley Gardens Blvd', NULL, 'Liverpool', NULL, 'WX1 6LT', 'UK', 1501, 92700),
	(202, 'Canadian Gift Exchange Network', 'Tamuri', 'Yoshi ', '(604) 555-3392', '1900 Oak St.', NULL, 'Vancouver', 'BC', 'V3F 2K1', 'Canada', 1323, 90300),
	(204, 'Online Mini Collectables', 'Barajas', 'Miguel', '6175557555', '7635 Spinnaker Dr.', NULL, 'Brickhaven', 'MA', '58339', 'USA', 1188, 68700),
	(205, 'Toys4GrownUps.com', 'Young', 'Julie', '6265557265', '78934 Hillside Dr.', NULL, 'Pasadena', 'CA', '90003', 'USA', 1166, 90700),
	(206, 'Asian Shopping Network, Co', 'Walker', 'Brydey', '+612 9411 1555', 'Suntec Tower Three', '8 Temasek', 'Singapore', NULL, '038988', 'Singapore', NULL, 0),
	(209, 'Mini Caravy', 'Citeaux', 'Frédérique ', '88.60.1555', '24, place Kléber', NULL, 'Strasbourg', NULL, '67000', 'France', 1370, 53800),
	(211, 'King Kong Collectables, Co.', 'Gao', 'Mike', '+852 2251 1555', 'Bank of China Tower', '1 Garden Road', 'Central Hong Kong', NULL, NULL, 'Hong Kong', 1621, 58600),
	(216, 'Enaco Distributors', 'Saavedra', 'Eduardo ', '(93) 203 4555', 'Rambla de Cataluña, 23', NULL, 'Barcelona', NULL, '08022', 'Spain', 1702, 60300),
	(219, 'Boards & Toys Co.', 'Young', 'Mary', '3105552373', '4097 Douglas Av.', NULL, 'Glendale', 'CA', '92561', 'USA', 1166, 11000),
	(223, 'Natürlich Autos', 'Kloss', 'Horst ', '0372-555188', 'Taucherstraße 10', NULL, 'Cunewalde', NULL, '01307', 'Germany', NULL, 0),
	(227, 'Heintze Collectables', 'Ibsen', 'Palle', '86 21 3555', 'Smagsloget 45', NULL, 'Århus', NULL, '8200', 'Denmark', 1401, 120800),
	(233, 'Québec Home Shopping Network', 'Fresnière', 'Jean ', '(514) 555-8054', '43 rue St. Laurent', NULL, 'Montréal', 'Québec', 'H1J 1C3', 'Canada', 1286, 48700),
	(237, 'ANG Resellers', 'Camino', 'Alejandra ', '(91) 745 6555', 'Gran Vía, 1', NULL, 'Madrid', NULL, '28001', 'Spain', NULL, 0),
	(239, 'Collectable Mini Designs Co.', 'Thompson', 'Valarie', '7605558146', '361 Furth Circle', NULL, 'San Diego', 'CA', '91217', 'USA', 1166, 105000),
	(240, 'giftsbymail.co.uk', 'Bennett', 'Helen ', '(198) 555-8888', 'Garden House', 'Crowther Way 23', 'Cowes', 'Isle of Wight', 'PO31 7PJ', 'UK', 1501, 93900),
	(242, 'Alpha Cognac', 'Roulet', 'Annette ', '61.77.6555', '1 rue Alsace-Lorraine', NULL, 'Toulouse', NULL, '31000', 'France', 1370, 61100),
	(247, 'Messner Shopping Network', 'Messner', 'Renate ', '069-0555984', 'Magazinweg 7', NULL, 'Frankfurt', NULL, '60528', 'Germany', NULL, 0),
	(249, 'Amica Models & Co.', 'Accorti', 'Paolo ', '011-4988555', 'Via Monte Bianco 34', NULL, 'Torino', NULL, '10100', 'Italy', 1401, 113000),
	(250, 'Lyon Souveniers', 'Da Silva', 'Daniel', '+33 1 46 62 7555', '27 rue du Colonel Pierre Avia', NULL, 'Paris', NULL, '75508', 'France', 1337, 68100),
	(256, 'Auto Associés & Cie.', 'Tonini', 'Daniel ', '30.59.8555', '67, avenue de l\'Europe', NULL, 'Versailles', NULL, '78000', 'France', 1370, 77900),
	(259, 'Toms Spezialitäten, Ltd', 'Pfalzheim', 'Henriette ', '0221-5554327', 'Mehrheimerstr. 369', NULL, 'Köln', NULL, '50739', 'Germany', 1504, 120400),
	(260, 'Royal Canadian Collectables, Ltd.', 'Lincoln', 'Elizabeth ', '(604) 555-4555', '23 Tsawassen Blvd.', NULL, 'Tsawassen', 'BC', 'T2F 8M4', 'Canada', 1323, 89600),
	(273, 'Franken Gifts, Co', 'Franken', 'Peter ', '089-0877555', 'Berliner Platz 43', NULL, 'München', NULL, '80805', 'Germany', NULL, 0),
	(276, 'Anna\'s Decorations, Ltd', 'O\'Hara', 'Anna', '02 9936 8555', '201 Miller Street', 'Level 15', 'North Sydney', 'NSW', '2060', 'Australia', 1611, 107800),
	(278, 'Rovelli Gifts', 'Rovelli', 'Giovanni ', '035-640555', 'Via Ludovico il Moro 22', NULL, 'Bergamo', NULL, '24100', 'Italy', 1401, 119600),
	(282, 'Souveniers And Things Co.', 'Huxley', 'Adrian', '+61 2 9495 8555', 'Monitor Money Building', '815 Pacific Hwy', 'Chatswood', 'NSW', '2067', 'Australia', 1611, 93300),
	(286, 'Marta\'s Replicas Co.', 'Hernandez', 'Marta', '6175558555', '39323 Spinnaker Dr.', NULL, 'Cambridge', 'MA', '51247', 'USA', 1216, 123700),
	(293, 'BG&E Collectables', 'Harrison', 'Ed', '+41 26 425 50 01', 'Rte des Arsenaux 41 ', NULL, 'Fribourg', NULL, '1700', 'Switzerland', NULL, 0),
	(298, 'Vida Sport, Ltd', 'Holz', 'Mihael', '0897-034555', 'Grenzacherweg 237', NULL, 'Genève', NULL, '1203', 'Switzerland', 1702, 141300),
	(299, 'Norway Gifts By Mail, Co.', 'Klaeboe', 'Jan', '+47 2212 1555', 'Drammensveien 126A', 'PB 211 Sentrum', 'Oslo', NULL, 'N 0106', 'Norway  ', 1504, 95100),
	(303, 'Schuyler Imports', 'Schuyler', 'Bradley', '+31 20 491 9555', 'Kingsfordweg 151', NULL, 'Amsterdam', NULL, '1043 GR', 'Netherlands', NULL, 0),
	(307, 'Der Hund Imports', 'Andersen', 'Mel', '030-0074555', 'Obere Str. 57', NULL, 'Berlin', NULL, '12209', 'Germany', NULL, 0),
	(311, 'Oulu Toy Supplies, Inc.', 'Koskitalo', 'Pirkko', '981-443655', 'Torikatu 38', NULL, 'Oulu', NULL, '90110', 'Finland', 1501, 90500),
	(314, 'Petit Auto', 'Dewey', 'Catherine ', '(02) 5554 67', 'Rue Joseph-Bens 532', NULL, 'Bruxelles', NULL, 'B-1180', 'Belgium', 1401, 79900),
	(319, 'Mini Classics', 'Frick', 'Steve', '9145554562', '3758 North Pendale Street', NULL, 'White Plains', 'NY', '24067', 'USA', 1323, 102700),
	(320, 'Mini Creations Ltd.', 'Huang', 'Wing', '5085559555', '4575 Hillside Dr.', NULL, 'New Bedford', 'MA', '50553', 'USA', 1188, 94500),
	(321, 'Corporate Gift Ideas Co.', 'Brown', 'Julie', '6505551386', '7734 Strong St.', NULL, 'San Francisco', 'CA', '94217', 'USA', 1165, 105000),
	(323, 'Down Under Souveniers, Inc', 'Graham', 'Mike', '+64 9 312 5555', '162-164 Grafton Road', 'Level 2', 'Auckland  ', NULL, NULL, 'New Zealand', 1612, 88000),
	(324, 'Stylish Desk Decors, Co.', 'Brown', 'Ann ', '(171) 555-0297', '35 King George', NULL, 'London', NULL, 'WX3 6FW', 'UK', 1501, 77000),
	(328, 'Tekni Collectables Inc.', 'Brown', 'William', '2015559350', '7476 Moss Rd.', NULL, 'Newark', 'NJ', '94019', 'USA', 1323, 43000),
	(333, 'Australian Gift Network, Co', 'Calaghan', 'Ben', '61-7-3844-6555', '31 Duncan St. West End', NULL, 'South Brisbane', 'Queensland', '4101', 'Australia', 1611, 51600),
	(334, 'Suominen Souveniers', 'Suominen', 'Kalle', '+358 9 8045 555', 'Software Engineering Center', 'SEC Oy', 'Espoo', NULL, 'FIN-02271', 'Finland', 1501, 98800),
	(335, 'Cramer Spezialitäten, Ltd', 'Cramer', 'Philip ', '0555-09555', 'Maubelstr. 90', NULL, 'Brandenburg', NULL, '14776', 'Germany', NULL, 0),
	(339, 'Classic Gift Ideas, Inc', 'Cervantes', 'Francisca', '2155554695', '782 First Street', NULL, 'Philadelphia', 'PA', '71270', 'USA', 1188, 81100),
	(344, 'CAF Imports', 'Fernandez', 'Jesus', '+34 913 728 555', 'Merchants House', '27-30 Merchant\'s Quay', 'Madrid', NULL, '28023', 'Spain', 1702, 59600),
	(347, 'Men \'R\' US Retailers, Ltd.', 'Chandler', 'Brian', '2155554369', '6047 Douglas Av.', NULL, 'Los Angeles', 'CA', '91003', 'USA', 1166, 57700),
	(348, 'Asian Treasures, Inc.', 'McKenna', 'Patricia ', '2967 555', '8 Johnstown Road', NULL, 'Cork', 'Co. Cork', NULL, 'Ireland', NULL, 0),
	(350, 'Marseille Mini Autos', 'Lebihan', 'Laurence ', '91.24.4555', '12, rue des Bouchers', NULL, 'Marseille', NULL, '13008', 'France', 1337, 65000),
	(353, 'Reims Collectables', 'Henriot', 'Paul ', '26.47.1555', '59 rue de l\'Abbaye', NULL, 'Reims', NULL, '51100', 'France', 1337, 81100),
	(356, 'SAR Distributors, Co', 'Kuger', 'Armand', '+27 21 550 3555', '1250 Pretorius Street', NULL, 'Hatfield', 'Pretoria', '0028', 'South Africa', NULL, 0),
	(357, 'GiftsForHim.com', 'MacKinlay', 'Wales', '64-9-3763555', '199 Great North Road', NULL, 'Auckland', NULL, NULL, 'New Zealand', 1612, 77700),
	(361, 'Kommission Auto', 'Josephs', 'Karin', '0251-555259', 'Luisenstr. 48', NULL, 'Münster', NULL, '44087', 'Germany', NULL, 0),
	(362, 'Gifts4AllAges.com', 'Yoshido', 'Juri', '6175559555', '8616 Spinnaker Dr.', NULL, 'Boston', 'MA', '51003', 'USA', 1216, 41900),
	(363, 'Online Diecast Creations Co.', 'Young', 'Dorothy', '6035558647', '2304 Long Airport Avenue', NULL, 'Nashua', 'NH', '62005', 'USA', 1216, 114200),
	(369, 'Lisboa Souveniers, Inc', 'Rodriguez', 'Lino ', '(1) 354-2555', 'Jardim das rosas n. 32', NULL, 'Lisboa', NULL, '1675', 'Portugal', NULL, 0),
	(376, 'Precious Collectables', 'Urs', 'Braun', '0452-076555', 'Hauptstr. 29', NULL, 'Bern', NULL, '3012', 'Switzerland', 1702, 0),
	(379, 'Collectables For Less Inc.', 'Nelson', 'Allen', '6175558555', '7825 Douglas Av.', NULL, 'Brickhaven', 'MA', '58339', 'USA', 1188, 70700),
	(381, 'Royale Belge', 'Cartrain', 'Pascale ', '(071) 23 67 2555', 'Boulevard Tirou, 255', NULL, 'Charleroi', NULL, 'B-6000', 'Belgium', 1401, 23500),
	(382, 'Salzburg Collectables', 'Pipps', 'Georg ', '6562-9555', 'Geislweg 14', NULL, 'Salzburg', NULL, '5020', 'Austria', 1401, 71700),
	(385, 'Cruz & Sons Co.', 'Cruz', 'Arnold', '+63 2 555 3587', '15 McCallum Street', 'NatWest Center #13-03', 'Makati City', NULL, '1227 MM', 'Philippines', 1621, 81500),
	(386, 'L\'ordine Souveniers', 'Moroni', 'Maurizio ', '0522-556555', 'Strada Provinciale 124', NULL, 'Reggio Emilia', NULL, '42100', 'Italy', 1401, 121400),
	(398, 'Tokyo Collectables, Ltd', 'Shimamura', 'Akiko', '+81 3 3584 0555', '2-2-8 Roppongi', NULL, 'Minato-ku', 'Tokyo', '106-0032', 'Japan', 1621, 94400),
	(406, 'Auto Canal+ Petit', 'Perrier', 'Dominique', '(1) 47.55.6555', '25, rue Lauriston', NULL, 'Paris', NULL, '75016', 'France', 1337, 95000),
	(409, 'Stuttgart Collectable Exchange', 'Müller', 'Rita ', '0711-555361', 'Adenauerallee 900', NULL, 'Stuttgart', NULL, '70563', 'Germany', NULL, 0),
	(412, 'Extreme Desk Decorations, Ltd', 'McRoy', 'Sarah', '04 499 9555', '101 Lambton Quay', 'Level 11', 'Wellington', NULL, NULL, 'New Zealand', 1612, 86800),
	(415, 'Bavarian Collectables Imports, Co.', 'Donnermeyer', 'Michael', ' +49 89 61 08 9555', 'Hansastr. 15', NULL, 'Munich', NULL, '80686', 'Germany', 1504, 77000),
	(424, 'Classic Legends Inc.', 'Hernandez', 'Maria', '2125558493', '5905 Pompton St.', 'Suite 750', 'NYC', 'NY', '10022', 'USA', 1286, 67500),
	(443, 'Feuer Online Stores, Inc', 'Feuer', 'Alexander ', '0342-555176', 'Heerstr. 22', NULL, 'Leipzig', NULL, '04179', 'Germany', NULL, 0),
	(447, 'Gift Ideas Corp.', 'Lewis', 'Dan', '2035554407', '2440 Pompton St.', NULL, 'Glendale', 'CT', '97561', 'USA', 1323, 49700),
	(448, 'Scandinavian Gift Ideas', 'Larsson', 'Martha', '0695-34 6555', 'Åkergatan 24', NULL, 'Bräcke', NULL, 'S-844 67', 'Sweden', 1504, 116400),
	(450, 'The Sharp Gifts Warehouse', 'Frick', 'Sue', '4085553659', '3086 Ingle Ln.', NULL, 'San Jose', 'CA', '94217', 'USA', 1165, 77600),
	(452, 'Mini Auto Werke', 'Mendel', 'Roland ', '7675-3555', 'Kirchgasse 6', NULL, 'Graz', NULL, '8010', 'Austria', 1401, 45300),
	(455, 'Super Scale Inc.', 'Murphy', 'Leslie', '2035559545', '567 North Pendale Street', NULL, 'New Haven', 'CT', '97823', 'USA', 1286, 95400),
	(456, 'Microscale Inc.', 'Choi', 'Yu', '2125551957', '5290 North Pendale Street', 'Suite 200', 'NYC', 'NY', '10022', 'USA', 1286, 39800),
	(458, 'Corrida Auto Replicas, Ltd', 'Sommer', 'Martín ', '(91) 555 22 82', 'C/ Araquil, 67', NULL, 'Madrid', NULL, '28023', 'Spain', 1702, 104600),
	(459, 'Warburg Exchange', 'Ottlieb', 'Sven ', '0241-039123', 'Walserweg 21', NULL, 'Aachen', NULL, '52066', 'Germany', NULL, 0),
	(462, 'FunGiftIdeas.com', 'Benitez', 'Violeta', '5085552555', '1785 First Street', NULL, 'New Bedford', 'MA', '50553', 'USA', 1216, 85800),
	(465, 'Anton Designs, Ltd.', 'Anton', 'Carmen', '+34 913 728555', 'c/ Gobelas, 19-1 Urb. La Florida', NULL, 'Madrid', NULL, '28023', 'Spain', NULL, 0),
	(471, 'Australian Collectables, Ltd', 'Clenahan', 'Sean', '61-9-3844-6555', '7 Allen Street', NULL, 'Glen Waverly', 'Victoria', '3150', 'Australia', 1611, 60300),
	(473, 'Frau da Collezione', 'Ricotti', 'Franco', '+39 022515555', '20093 Cologno Monzese', 'Alessandro Volta 16', 'Milan', NULL, NULL, 'Italy', 1401, 34800),
	(475, 'West Coast Collectables Co.', 'Thompson', 'Steve', '3105553722', '3675 Furth Circle', NULL, 'Burbank', 'CA', '94019', 'USA', 1166, 55400),
	(477, 'Mit Vergnügen & Co.', 'Moos', 'Hanna ', '0621-08555', 'Forsterstr. 57', NULL, 'Mannheim', NULL, '68306', 'Germany', NULL, 0),
	(480, 'Kremlin Collectables, Co.', 'Semenov', 'Alexander ', '+7 812 293 0521', '2 Pobedy Square', NULL, 'Saint Petersburg', NULL, '196143', 'Russia', NULL, 0),
	(481, 'Raanan Stores, Inc', 'Altagar,G M', 'Raanan', '+ 972 9 959 8555', '3 Hagalim Blv.', NULL, 'Herzlia', NULL, '47625', 'Israel', NULL, 0),
	(484, 'Iberia Gift Imports, Corp.', 'Roel', 'José Pedro ', '(95) 555 82 82', 'C/ Romero, 33', NULL, 'Sevilla', NULL, '41101', 'Spain', 1702, 65700),
	(486, 'Motor Mint Distributors Inc.', 'Salazar', 'Rosa', '2155559857', '11328 Douglas Av.', NULL, 'Philadelphia', 'PA', '71270', 'USA', 1323, 72600),
	(487, 'Signal Collectibles Ltd.', 'Taylor', 'Sue', '4155554312', '2793 Furth Circle', NULL, 'Brisbane', 'CA', '94217', 'USA', 1165, 60300),
	(489, 'Double Decker Gift Stores, Ltd', 'Smith', 'Thomas ', '(171) 555-7555', '120 Hanover Sq.', NULL, 'London', NULL, 'WA1 1DP', 'UK', 1501, 43300),
	(495, 'Diecast Collectables', 'Franco', 'Valarie', '6175552555', '6251 Ingle Ln.', NULL, 'Boston', 'MA', '51003', 'USA', 1188, 85100),
	(496, 'Kelly\'s Gift Shop', 'Snowden', 'Tony', '+64 9 5555500', 'Arenales 1938 3\'A\'', NULL, 'Auckland  ', NULL, NULL, 'New Zealand', 1612, 110000);
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;

-- Dump della struttura di tabella sampledb.orderdetails
CREATE TABLE IF NOT EXISTS `orderdetails` (
  `orderNumber` int(11) NOT NULL,
  `productCode` varchar(15) NOT NULL,
  `quantityOrdered` int(11) NOT NULL,
  `priceEach` double NOT NULL,
  `orderLineNumber` smallint(6) NOT NULL,
  PRIMARY KEY (`orderNumber`,`productCode`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Dump dei dati della tabella sampledb.orderdetails: 102 rows
/*!40000 ALTER TABLE `orderdetails` DISABLE KEYS */;
INSERT INTO `orderdetails` (`orderNumber`, `productCode`, `quantityOrdered`, `priceEach`, `orderLineNumber`) VALUES
	(10100, 'S18_1749', 30, 136, 3),
	(10100, 'S18_2248', 50, 55.09, 2),
	(10100, 'S18_4409', 22, 75.46, 4),
	(10100, 'S24_3969', 49, 35.29, 1),
	(10101, 'S18_2325', 25, 108.06, 4),
	(10101, 'S18_2795', 26, 167.06, 1),
	(10101, 'S24_1937', 45, 32.53, 3),
	(10101, 'S24_2022', 46, 44.35, 2),
	(10102, 'S18_1342', 39, 95.55, 2),
	(10102, 'S18_1367', 41, 43.13, 1),
	(10103, 'S10_1949', 26, 214.3, 11),
	(10103, 'S10_4962', 42, 119.67, 4),
	(10103, 'S12_1666', 27, 121.64, 8),
	(10103, 'S18_1097', 35, 94.5, 10),
	(10103, 'S18_2432', 22, 58.34, 2),
	(10103, 'S18_2949', 27, 92.19, 12),
	(10103, 'S18_2957', 35, 61.84, 14),
	(10103, 'S18_3136', 25, 86.92, 13),
	(10103, 'S18_3320', 46, 86.31, 16),
	(10103, 'S18_4600', 36, 98.07, 5),
	(10103, 'S18_4668', 41, 40.75, 9),
	(10103, 'S24_2300', 36, 107.34, 1),
	(10103, 'S24_4258', 25, 88.62, 15),
	(10103, 'S32_1268', 31, 92.46, 3),
	(10103, 'S32_3522', 45, 63.35, 7),
	(10103, 'S700_2824', 42, 94.07, 6),
	(10104, 'S12_3148', 34, 131.44, 1),
	(10104, 'S12_4473', 41, 111.39, 9),
	(10104, 'S18_2238', 24, 135.9, 8),
	(10104, 'S18_2319', 29, 122.73, 12),
	(10104, 'S18_3232', 23, 165.95, 13),
	(10104, 'S18_4027', 38, 119.2, 3),
	(10104, 'S24_1444', 35, 52.02, 6),
	(10104, 'S24_2840', 44, 30.41, 10),
	(10104, 'S24_4048', 26, 106.45, 5),
	(10104, 'S32_2509', 35, 51.95, 11),
	(10104, 'S32_3207', 49, 56.55, 4),
	(10104, 'S50_1392', 33, 114.59, 7),
	(10104, 'S50_1514', 32, 53.31, 2),
	(10105, 'S10_4757', 50, 127.84, 2),
	(10105, 'S12_1108', 41, 205.72, 15),
	(10105, 'S12_3891', 29, 141.88, 14),
	(10105, 'S18_3140', 22, 136.59, 11),
	(10105, 'S18_3259', 38, 87.73, 13),
	(10105, 'S18_4522', 41, 75.48, 10),
	(10105, 'S24_2011', 43, 117.97, 9),
	(10105, 'S24_3151', 44, 73.46, 4),
	(10105, 'S24_3816', 50, 75.47, 1),
	(10105, 'S700_1138', 41, 54, 5),
	(10105, 'S700_1938', 29, 86.61, 12),
	(10105, 'S700_2610', 31, 60.72, 3),
	(10105, 'S700_3505', 39, 92.16, 6),
	(10105, 'S700_3962', 22, 99.31, 7),
	(10105, 'S72_3212', 25, 44.77, 8),
	(10106, 'S18_1662', 36, 134.04, 12),
	(10106, 'S18_2581', 34, 81.1, 2),
	(10106, 'S18_3029', 41, 80.86, 18),
	(10106, 'S18_3856', 41, 94.22, 17),
	(10106, 'S24_1785', 28, 107.23, 4),
	(10106, 'S24_2841', 49, 65.77, 13),
	(10106, 'S24_3420', 31, 55.89, 14),
	(10106, 'S24_3949', 50, 55.96, 11),
	(10106, 'S24_4278', 26, 71, 3),
	(10106, 'S32_4289', 33, 65.35, 5),
	(10106, 'S50_1341', 39, 35.78, 6),
	(10106, 'S700_1691', 31, 91.34, 7),
	(10106, 'S700_2047', 30, 85.09, 16),
	(10106, 'S700_2466', 34, 99.72, 9),
	(10106, 'S700_2834', 32, 113.9, 1),
	(10106, 'S700_3167', 44, 76, 8),
	(10106, 'S700_4002', 48, 70.33, 10),
	(10106, 'S72_1253', 48, 43.7, 15),
	(10107, 'S10_1678', 30, 81.35, 2),
	(10107, 'S10_2016', 39, 105.86, 5),
	(10107, 'S10_4698', 27, 172.36, 4),
	(10107, 'S12_2823', 21, 122, 1),
	(10107, 'S18_2625', 29, 52.7, 6),
	(10107, 'S24_1578', 25, 96.92, 3),
	(10107, 'S24_2000', 38, 73.12, 7),
	(10107, 'S32_1374', 20, 88.9, 8),
	(10108, 'S12_1099', 33, 165.38, 6),
	(10108, 'S12_3380', 45, 96.3, 4),
	(10108, 'S12_3990', 39, 75.81, 7),
	(10108, 'S12_4675', 36, 107.1, 3),
	(10108, 'S18_1889', 38, 67.76, 2),
	(10108, 'S18_3278', 26, 73.17, 9),
	(10108, 'S18_3482', 29, 132.29, 8),
	(10108, 'S18_3782', 43, 52.84, 12),
	(10108, 'S18_4721', 44, 139.87, 11),
	(10108, 'S24_2360', 35, 64.41, 15),
	(10108, 'S24_3371', 30, 60.01, 5),
	(10108, 'S24_3856', 40, 132, 1),
	(10108, 'S24_4620', 31, 67.1, 10),
	(10108, 'S32_2206', 27, 36.21, 13),
	(10108, 'S32_4485', 31, 87.76, 16),
	(10108, 'S50_4713', 34, 74.85, 14),
	(10109, 'S18_1129', 26, 117.48, 4),
	(10109, 'S18_1984', 38, 137.98, 3),
	(10109, 'S18_2870', 26, 126.72, 1),
	(10109, 'S18_3232', 46, 160.87, 5),
	(10109, 'S18_3685', 47, 125.74, 2),
	(10109, 'S24_2972', 29, 32.1, 6);
/*!40000 ALTER TABLE `orderdetails` ENABLE KEYS */;

-- Dump della struttura di tabella sampledb.orders
CREATE TABLE IF NOT EXISTS `orders` (
  `orderNumber` int(11) NOT NULL,
  `orderDate` datetime NOT NULL,
  `requiredDate` datetime NOT NULL,
  `shippedDate` datetime DEFAULT NULL,
  `status` varchar(15) NOT NULL,
  `comments` text DEFAULT NULL,
  `customerNumber` int(11) NOT NULL,
  `color` varchar(12) DEFAULT '' COMMENT 'Ciolor hex format, eg. FFFFFF (white)',
  PRIMARY KEY (`orderNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Dump dei dati della tabella sampledb.orders: 10 rows
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` (`orderNumber`, `orderDate`, `requiredDate`, `shippedDate`, `status`, `comments`, `customerNumber`, `color`) VALUES
	(10100, '2003-01-06 00:00:00', '2003-11-13 00:00:00', '2003-01-10 00:00:00', 'Shipped', 'Customer requested that FedEx Ground is used for this shipping', 363, 'FFD480'),
	(10101, '2003-01-18 00:00:00', '2003-01-31 00:00:00', '2003-01-22 00:00:00', 'Shipped', 'Check on availability.', 128, 'EAFF80'),
	(10102, '2003-01-10 00:00:00', '1918-11-23 00:00:00', '1946-04-10 00:00:00', 'Shipped', 'Customer requested special shippment. The instructions were passed along to the warehouse', 181, 'B0BF1A'),
	(10103, '2003-01-29 00:00:00', '2003-02-19 00:00:00', '2003-02-02 00:00:00', 'Shipped', 'Customer has worked with some of our vendors in the past and is aware of their MSRP', 141, '7CB9E8'),
	(10104, '2003-01-25 00:00:00', '2003-02-09 00:00:00', '2003-04-24 00:00:00', 'Shipped', '', 141, 'B284BE'),
	(10105, '2003-02-11 00:00:00', '2003-02-21 00:00:00', '2003-02-12 00:00:00', 'Shipped', 'Urgent', 145, '5D8AA8'),
	(10106, '2003-02-17 00:00:00', '2003-02-24 00:00:00', '2003-02-21 00:00:00', 'Shipped', 'Foobar using XML as datasource', 278, 'FFBF00'),
	(10107, '2003-02-24 00:00:00', '2003-03-03 00:00:00', '2003-02-26 00:00:00', 'Shipped', 'Difficult to negotiate with customer. We need more marketing materials', 131, 'FF198C'),
	(10108, '2003-03-03 00:00:00', '2003-03-12 12:10:00', '2008-03-12 00:00:00', 'Shipped', 'Shipping ASAP', 385, '667FFF'),
	(10109, '2003-03-10 00:00:00', '2003-03-19 00:00:00', '2003-03-11 00:00:00', 'Shipped', 'Customer requested that FedEx Ground is used for this shipping', 486, 'FF6666');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;

-- Dump della struttura di tabella sampledb.productlines
CREATE TABLE IF NOT EXISTS `productlines` (
  `productLine` varchar(50) NOT NULL,
  `textDescription` varchar(4000) DEFAULT NULL,
  `htmlDescription` mediumtext DEFAULT NULL,
  `image` mediumblob DEFAULT NULL,
  PRIMARY KEY (`productLine`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Dump dei dati della tabella sampledb.productlines: 7 rows
/*!40000 ALTER TABLE `productlines` DISABLE KEYS */;
INSERT INTO `productlines` (`productLine`, `textDescription`, `htmlDescription`, `image`) VALUES
	('Classic Cars', 'Attention car enthusiasts: Make your wildest car ownership dreams come true. Whether you are looking for classic muscle cars, dream sports cars or movie-inspired miniatures, you will find great choices in this category. These replicas feature superb attention to detail and craftsmanship and offer features such as working steering system, opening forward compartment, opening rear trunk with removable spare wheel, 4-wheel independent spring suspension, and so on. The models range in size from 1:10 to 1:24 scale and include numerous limited edition and several out-of-production vehicles. All models include a certificate of authenticity from their manufacturers and come fully assembled and ready for display in the home or office.', NULL, _binary 0x70687047726964782f53616d706c65496d616765732f70686f746f732f636c61737369635f6361722e6a7067),
	('Motorcycles', 'Our motorcycles are state of the art replicas of classic as well as contemporary motorcycle legends such as Harley Davidson, Ducati and Vespa. Models contain stunning details such as official logos, rotating wheels, working kickstand, front suspension, gear-shift lever, footbrake lever, and drive chain. Materials used include diecast and plastic. The models range in size from 1:10 to 1:50 scale and include numerous limited edition and several out-of-production vehicles. All models come fully assembled and ready for display in the home or office. Most include a certificate of authenticity.', NULL, _binary 0x70687047726964782f53616d706c65496d616765732f70686f746f732f6d6f746f726379636c652e6a7067),
	('Planes', 'Unique, diecast airplane and helicopter replicas suitable for collections, as well as home, office or classroom decorations. Models contain stunning details such as official logos and insignias, rotating jet engines and propellers, retractable wheels, and so on. Most come fully assembled and with a certificate of authenticity from their manufacturers.', NULL, _binary 0x70687047726964782f53616d706c65496d616765732f70686f746f732f616972706c616e652e6a7067),
	('Ships', 'The perfect holiday or anniversary gift for executives, clients, friends, and family. These handcrafted model ships are unique, stunning works of art that will be treasured for generations! They come fully assembled and ready for display in the home or office. We guarantee the highest quality, and best value.', NULL, _binary 0x70687047726964782f53616d706c65496d616765732f70686f746f732f736869702e676966),
	('Trains', 'Model trains are a rewarding hobby for enthusiasts of all ages. Whether you\'re looking for collectible wooden trains, electric streetcars or locomotives, you\'ll find a number of great choices for any budget within this category. The interactive aspect of trains makes toy trains perfect for young children. The wooden train sets are ideal for children under the age of 5.', NULL, _binary 0x70687047726964782f53616d706c65496d616765732f70686f746f732f747261696e2e6a7067),
	('Trucks and Buses', 'The Truck and Bus models are realistic replicas of buses and specialized trucks produced from the early 1920s to present. The models range in size from 1:12 to 1:50 scale and include numerous limited edition and several out-of-production vehicles. Materials used include tin, diecast and plastic. All models include a certificate of authenticity from their manufacturers and are a perfect ornament for the home and office.', NULL, _binary 0x70687047726964782f53616d706c65496d616765732f70686f746f732f747275636b2e6a7067),
	('Vintage Cars', 'Our Vintage Car models realistically portray automobiles produced from the early 1900s through the 1940s. Materials used include Bakelite, diecast, plastic and wood. Most of the replicas are in the 1:18 and 1:24 scale sizes, which provide the optimum in detail and accuracy. Prices range from $30.00 up to $180.00 for some special limited edition replicas. All models include a certificate of authenticity from their manufacturers and come fully assembled and ready for display in the home or office.', NULL, _binary 0x70687047726964782f53616d706c65496d616765732f70686f746f732f76696e746167655f6361722e6a7067);
/*!40000 ALTER TABLE `productlines` ENABLE KEYS */;

-- Dump della struttura di tabella sampledb.products
CREATE TABLE IF NOT EXISTS `products` (
  `productCode` varchar(15) NOT NULL,
  `productName` varchar(70) NOT NULL,
  `productUrl` varchar(50) DEFAULT NULL,
  `productLine` varchar(50) NOT NULL,
  `productScale` varchar(10) NOT NULL,
  `productVendor` varchar(50) NOT NULL,
  `productDescription` text NOT NULL,
  `quantityInStock` smallint(6) NOT NULL,
  `buyPrice` double NOT NULL,
  `MSRP` double NOT NULL,
  `Image` varchar(50) DEFAULT 'phpGridx/SampleImages/motorcycle.jpg',
  `supplierZip` varchar(55) DEFAULT NULL,
  PRIMARY KEY (`productCode`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Dump dei dati della tabella sampledb.products: 113 rows
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` (`productCode`, `productName`, `productUrl`, `productLine`, `productScale`, `productVendor`, `productDescription`, `quantityInStock`, `buyPrice`, `MSRP`, `Image`, `supplierZip`) VALUES
	('11', 'test', 'test', 'test', 'test', 'tes', 'testzzzbbbb', 1, 100, 199, '', '91111'),
	('S10_111', '2000 Benz', 'N/A', 'Motocycle', '1:50', 'MINIME', 'N/A', 100, 20000, 40000, NULL, '91801'),
	('S10_1111', '1999 De Loren', '', 'Classic Car', '1:12', 'Mini', 'DOA', 111, 80808, 90000, '', '91801-3328'),
	('S10_1678', '1969 Harley Davidson Ultimate Chopper', 'http://harleydavidson.com', 'Motocycle', '1:10', 'Min Lin Diecastzzzz', 'This replica features working kickstand, front suspension, gear-shift lever, footbrake lever, drive chain, wheels and steering. All parts are particularly delicate due to their precise scale and require special care and attention.', 7933, 48.81, 95.7, 'SampleImages/motorcycle.jpg', '91801-3328'),
	('S10_1949', '1952 Alpine Renault 1300', 'http://alpinerenault.com', 'Classic Cars', '1:100', 'Classic Metal Creations', 'Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 7305, 98.58, 214.3, 'SampleImages/classic_car.png', '91801-3328'),
	('S10_2016', '1996 Moto Guzzi 1100i', 'http://motoguzzi.com', 'Motorcyclessasdfsasf', '1:10', 'Highway 66 Mini Classics', 'Official Moto Guzzi logos and insignias, saddle bags located on side of motorcycle, detailed engine, working steering, working suspension, two leather seats, luggage rack, dual exhaust pipes, small saddle bag located on handle bars, two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand, diecast metal with plastic parts and baked enamel finish.', 6625, 68.99, 118.94, 'SampleImages/motorcycle.jpg', '91801-3328'),
	('S10_4698', '2003 Harley-Davidson Eagle Drag Bike', NULL, 'Motorcycles', '1:10', 'Red Start Diecast', 'Model features, official Harley Davidson logos and insignias, detachable rear wheelie bar, heavy diecast metal with resin parts, authentic multi-color tampo-printed graphics, separate engine drive belts, free-turning front fork, rotating tires and rear racing slick, certificate of authenticity, detailed engine, display stand\r\n, precision diecast replica, baked enamel finish, 1:10 scale model, removable fender, seat and tank cover piece for displaying the superior detail of the v-twin engine', 5582, 91.02, 193.66, 'SampleImages/motorcycle.jpg', '91801-1949'),
	('S10_4757', '1972 Alfa Romeo GTA', '', 'Classic Cars', '1:10', 'Motor City Art Classics', 'Features include: Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 3252, 85.68, 136, 'SampleImages/classic_car.png', '91801-1949'),
	('S10_4962', '1962 LanciaA Delta 16V', NULL, 'Classic Cars', '1:10', 'Second Gear Diecast', 'Features include: Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 6791, 103.42, 147.74, 'SampleImages/classic_car.png', '91801-1949'),
	('S12_1099', '1968 Ford Mustang', 'http://ford.com', 'Classic Cars', '1:12', 'Autoart Studio Design', 'Hood, doors and trunk all open to reveal highly detailed interior features. Steering wheel actually turns the front wheels. Color dark green.', 68, 95.34, 194.57, 'SampleImages/classic_car.png', '91111'),
	('S12_1108', '2001 Ferrari Enzo', 'http://ferrari.com', 'Classic Cars', '1:12', 'Second Gear Diecast', 'Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 3619, 95.59, 207.8, 'SampleImages/classic_car.png', '91801-1949'),
	('S12_1666', '1958 Setra Bus', NULL, 'Trucks and Buses', '1:12', 'Welly Diecast Productions', 'Model features 30 windows, skylights & glare resistant glass, working steering system, original logos', 1579, 77.9, 136.67, 'SampleImages/truck.jpg', '91801-1949'),
	('S12_2823', '2002 Suzuki XREO', 'n/a', 'Motorcycles', '1:12', 'Unimax Art Galleries', 'Official logos and insignias, saddle bags located on side of motorcycle, detailed engine, working steering, working suspension, two leather seats, luggage rack, dual exhaust pipes, small saddle bag located on handle bars, two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand, diecast metal with plastic parts and baked enamel finish.', 9997, 66.27, 150.62, 'SampleImages/motorcycle.jpg', '91801-1949'),
	('S12_3148', '1969 Corvair Monza', 'N/A', 'Classic Cars', '1:18', 'Welly Diecast Productions', '1:18 scale die-cast about 10" long doors open, hood opens, trunk opens and wheels roll', 6906, 89.14, 151.08, 'SampleImages/classic_car.png', '91801-3328'),
	('S12_3380', '1968 Dodge Charger', 'http://dodge.com', 'Classic Cars', '1:12', 'Welly Diecast Productions', '1:12 scale model of a 1968 Dodge Charger. Hood, doors and trunk all open to reveal highly detailed interior features. Steering wheel actually turns the front wheels. Color black', 9123, 75.16, 117.44, 'SampleImages/classic_car.png', '91801-1949'),
	('S12_3891', '1969 Ford Falcon', NULL, 'Classic Cars', '1:12', 'Second Gear Diecast', 'Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.xxxxxx', 1049, 83.05, 173.02, 'SampleImages/classic_car.png', '91801-3328'),
	('S12_3990', '1970 Plymouth Hemi Cuda', NULL, 'Classic Cars', '1:12', 'Studio M Art Models', 'Very detailed 1970 Plymouth Cuda model in 1:12 scale. The Cuda is generally accepted as one of the fastest original muscle cars from the 1970s. This model is a reproduction of one of the orginal 652 cars built in 1970. Red color.', 5663, 31.92, 79.8, 'SampleImages/classic_car.png', '91801-1949'),
	('S12_4473', '1957 Chevy Pickup', NULL, 'Trucks and Buses', '1:12', 'Exoto Designs', '1:12 scale die-cast about 20" long Hood opens, Rubber wheels', 6125, 55.7, 118.5, 'SampleImages/truck.jpg', '91801-3328'),
	('S12_4675', '1969 Dodge Charger', 'http://dodge.com', 'Classic Cars', '1:12', 'Welly Diecast Productions', 'Detailed model of the 1969 Dodge Charger. This model includes finely detailed interior and exterior features. Painted in red and white.', 7323, 58.73, 115.16, 'SampleImages/classic_car.png', '91801-1949'),
	('S18_1097', '1940 Ford Pickup Truck', NULL, 'Trucks and Buses', '1:18', 'Studio M Art Models', 'This model features soft rubber tires, working steering, rubber mud guards, authentic Ford logos, detailed undercarriage, opening doors and hood,  removable split rear gate, full size spare mounted in bed, detailed interior with opening glove box', 2613, 588888.33, 116.67, 'SampleImages/truck.jpg', '91801-3328'),
	('S18_1129', '1993 Mazda RX-7', NULL, 'Classic Cars', '1:18', 'Highway 66 Mini Classics', 'This model features, opening hood, opening doors, detailed engine, rear spoiler, opening trunk, working steering, tinted windows, baked enamel finish. Color red.', 3975, 8888.51, 1889999.54, 'SampleImages/classic_car.png', '91801-3328'),
	('S18_1342', '1937 Lincoln Berline', NULL, 'Vintage Cars', '1:18', 'Motor City Art Classics', 'Features opening engine cover, doors, trunk, and fuel filler cap. Color black', 8693, 60.62, 102.74, 'SampleImages/vintage_car.png', '91801-3328'),
	('S18_1367', '1936 Mercedes-Benz 500K Special Roadster', 'http://mercedesbenz.com', 'Vintage Cars', '1:18', 'Studio M Art Models', 'This 1:18 scale replica is constructed of heavy die-cast metal and has all the features of the original: working doors and rumble seat, independent spring suspension, detailed interior, working steering system, and a bifold hood that reveals an engine so accurate that it even includes the wiring. All this is topped off with a baked enamel finish. Color white.', 8635, 24.26, 53.91, 'SampleImages/vintage_car.png', '91801-1949'),
	('S18_1589', '1965 Aston Martin DB5', NULL, 'Classic Cars', '1:18', 'Classic Metal Creations', 'Die-cast model of the silver 1965 Aston Martin DB5 in silver. This model includes full wire wheels and doors that open with fully detailed passenger compartment. In 1:18 scale, this model measures approximately 10 inches/20 cm long.', 9042, 65.96, 124.44, 'SampleImages/classic_car.png', NULL),
	('S18_1662', '1980s Black Hawk Helicopter', NULL, 'Planes', '1:18', 'Red Start Diecast', '1:18 scale replica of actual Army\'s UH-60L BLACK HAWK Helicopter. 100% hand-assembled. Features rotating rotor blades, propeller blades and rubber wheels.', 5330, 77.27, 157.69, 'SampleImages/motorcycle.jpg', NULL),
	('S18_1749', '1917 Grand Touring Sedan', 'http://fuckingawesome.com', 'Vintage Cars', '1:18', 'Welly Diecast Productions', 'This 1:18 scale replica of the 1917 Grand Touring car has all the features you would expect from museum quality reproductions: all four doors and bi-fold hood opening, detailed engine and instrument panel, chrome-look trim, and tufted upholstery, all topped off with a factory baked-enamel finish.', 2724, 86.7, 170, 'SampleImages/vintage_car.png', ''),
	('S18_1889', '1948 Porsche 356-A Roadster', 'http://porsche.com', 'Classic Cars', '1:18', 'Gearbox Collectibles', 'This precision die-cast replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 8826, 53.9, 77, 'SampleImages/classic_car.png', NULL),
	('S18_1984', '1995 Honda Civic', 'http://honda.com', 'Classic Cars', '1:18', 'Min Lin Diecast', 'This model features, opening hood, opening doors, detailed engine, rear spoiler, opening trunk, working steering, tinted windows, baked enamel finish. Color yellow.', 9772, 93.89, 142.25, 'SampleImages/classic_car.png', NULL),
	('S18_2238', '1998 Chrysler Plymouth Prowler', NULL, 'Classic Cars', '1:18', 'Gearbox Collectibles', 'Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 4724, 101.51, 163.73, 'SampleImages/classic_car.png', NULL),
	('S18_2248', '1911 Ford Town Car', NULL, 'Vintage Cars', '1:18', 'Motor City Art Classics', 'Features opening hood, opening doors, opening trunk, wide white wall tires, front door arm rests, working steering system.', 540, 33.3, 60.54, 'SampleImages/vintage_car.png', NULL),
	('S18_2319', '1964 Mercedes Tour Bus', 'http://ford.com', 'Trucks and Buses', '1:18', 'Unimax Art Galleries', 'Exact replica. 100+ parts. working steering system, original logos', 8258, 74.86, 122.73, 'SampleImages/truck.jpg', NULL),
	('S18_2325', '1932 Model A Ford J-Coupe', 'http://ford.com', 'Vintage Cars', '1:18', 'Autoart Studio Design', 'This model features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system, chrome-covered spare, opening doors, detailed and wired engine', 9354, 58.48, 127.13, 'SampleImages/vintage_car.png', NULL),
	('S18_2432', '1926 Ford Fire Engine', NULL, 'Trucks and Buses', '1:18', 'Carousel DieCast Legends', 'Gleaming red handsome appearance. Everything is here the fire hoses, ladder, axes, bells, lanterns, ready to fight any inferno.', 2018, 24.92, 60.77, 'SampleImages/truck.jpg', NULL),
	('S18_2581', 'P-51-D Mustang', NULL, 'Planes', '1:72', 'Gearbox Collectibles', 'Has retractable wheels and comes with a stand', 992, 49, 84.48, 'SampleImages/motorcycle.jpg', NULL),
	('S18_2625', '1936 Harley Davidson El Knucklehead', NULL, 'Motorcycles', '1:18', 'Welly Diecast Productions', 'Intricately detailed with chrome accents and trim, official die-struck logos and baked enamel finish.', 4357, 24.23, 60.57, 'SampleImages/motorcycle.jpg', NULL),
	('S18_2795', '1928 Mercedes-Benz SSK', NULL, 'Vintage Cars', '1:18', 'Gearbox Collectibles', 'This 1:18 replica features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system, chrome-covered spare, opening doors, detailed and wired engine. Color black.', 548, 72.56, 168.75, 'SampleImages/vintage_car.png', NULL),
	('S18_2870', '1999 Indy 500 Monte Carlo SS', NULL, 'Classic Cars', '1:18', 'Red Start Diecast', 'Features include opening and closing doors. Color: Red', 8164, 56.76, 132, 'SampleImages/classic_car.png', NULL),
	('S18_2949', '1913 Ford Model T Speedster', NULL, 'Vintage Cars', '1:18', 'Carousel DieCast Legends', 'This 250 part reproduction includes moving handbrakes, clutch, throttle and foot pedals, squeezable horn, detailed wired engine, removable water, gas, and oil cans, pivoting monocle windshield, all topped with a baked enamel red finish. Each replica comes with an Owners Title and Certificate of Authenticity. Color red.', 4189, 60.78, 101.31, 'SampleImages/vintage_car.png', NULL),
	('S18_2957', '1934 Ford V8 Coupe', NULL, 'Vintage Cars', '1:18', 'Min Lin Diecast', 'Chrome Trim, Chrome Grille, Opening Hood, Opening Doors, Opening Trunk, Detailed Engine, Working Steering System', 5649, 34.35, 62.46, 'SampleImages/vintage_car.png', NULL),
	('S18_3029', '1999 Yamaha Speed Boat', NULL, 'Ships', '1:18', 'Min Lin Diecast', 'Exact replica. Wood and Metal. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with three masts, all square-rigged.', 4259, 51.61, 86.02, 'SampleImages/motorcycle.jpg', '91801-3328'),
	('S18_3136', '18th Century Vintage Horse Carriage', NULL, 'Vintage Cars', '1:18', 'Red Start Diecast', 'Hand crafted diecast-like metal horse carriage is re-created in about 1:18 scale of antique horse carriage. This antique style metal Stagecoach is all hand-assembled with many different parts.\r\n\r\nThis collectible metal horse carriage is painted in classic Red, and features turning steering wheel and is entirely hand-finished.', 5992, 60.74, 104.72, 'SampleImages/vintage_car.png', NULL),
	('S18_3140', '1903 Ford Model A', NULL, 'Vintage Cars', '1:18', 'Unimax Art Galleries', 'Features opening trunk,  working steering system', 3913, 68.3, 136.59, 'SampleImages/vintage_car.png', NULL),
	('S18_3232', '1992 Ferrari 360 Spider red', NULL, 'Classic Cars', '1:18', 'Unimax Art Galleries', 'his replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 8347, 77.9, 169.34, 'SampleImages/classic_car.png', NULL),
	('S18_3233', '1985 Toyota Supra', NULL, 'Classic Cars', '1:18', 'Highway 66 Mini Classics', 'This model features soft rubber tires, working steering, rubber mud guards, authentic Ford logos, detailed undercarriage, opening doors and hood, removable split rear gate, full size spare mounted in bed, detailed interior with opening glove box', 7733, 57.01, 107.57, 'SampleImages/classic_car.png', NULL),
	('S18_3259', 'Collectable Wooden Train', NULL, 'Trains', '1:18', 'Carousel DieCast Legends', 'Hand crafted wooden toy train set is in about 1:18 scale, 25 inches in total length including 2 additional carts, of actual vintage train. This antique style wooden toy train model set is all hand-assembled with 100% wood.', 6450, 67.56, 100.84, 'SampleImages/motorcycle.jpg', '91801-3328'),
	('S18_3278', '1969 Dodge Super Bee', NULL, 'Classic Cars', '1:18', 'Min Lin Diecast', 'This replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 1917, 49.05, 80.41, 'SampleImages/classic_car.png', '91111'),
	('S18_3320', '1917 Maxwell Touring Car', NULL, 'Vintage Cars', '1:18', 'Exoto Designs', 'Features Gold Trim, Full Size Spare Tire, Chrome Trim, Chrome Grille, Opening Hood, Opening Doors, Opening Trunk, Detailed Engine, Working Steering System', 7913, 57.54, 99.21, 'SampleImages/vintage_car.png', NULL),
	('S18_3482', '1976 Ford Gran Torino', NULL, 'Classic Cars', '1:18', 'Gearbox Collectibles', 'Highly detailed 1976 Ford Gran Torino "Starsky and Hutch" diecast model. Very well constructed and painted in red and white patterns.', 9127, 73.49, 146.99, 'SampleImages/classic_car.png', '91111'),
	('S18_3685', '1948 Porsche Type 356 Roadster', NULL, 'Classic Cars', '1:18', 'Gearbox Collectibles', 'This model features working front and rear suspension on accurately replicated and actuating shock absorbers as well as opening engine cover, rear stabilizer flap,  and 4 opening doors.', 8990, 62.16, 141.28, 'SampleImages/classic_car.png', NULL),
	('S18_3782', '1957 Vespa GS150', NULL, 'Motorcycles', '1:18', 'Studio M Art Models', 'Features rotating wheels , working kick stand. Comes with stand.', 7689, 32.95, 62.17, 'SampleImages/motorcycle.jpg', '91111'),
	('S18_3856', '1941 Chevrolet Special Deluxe Cabriolet', NULL, 'Vintage Cars', '1:18', 'Exoto Designs', 'Features opening hood, opening doors, opening trunk, wide white wall tires, front door arm rests, working steering system, leather upholstery. Color black.', 2378, 64.58, 105.87, 'SampleImages/vintage_car.png', '91111'),
	('S18_4027', '1970 Triumph Spitfire', NULL, 'Classic Cars', '1:18', 'Min Lin Diecast', 'Features include opening and closing doors. Color: White.', 5545, 91.92, 143.62, 'SampleImages/classic_car.png', '91111'),
	('S18_4409', '1932 Alfa Romeo 8C2300 Spider Sport', NULL, 'Vintage Cars', '1:18', 'Exoto Designs', 'This 1:18 scale precision die cast replica features the 6 front headlights of the original, plus a detailed version of the 142 horsepower straight 8 engine, dual spares and their famous comprehensive dashboard. Color black.', 6553, 43.26, 92.03, 'SampleImages/vintage_car.png', NULL),
	('S18_4522', '1904 Buick Runabout', NULL, 'Vintage Cars', '1:18', 'Exoto Designs', 'Features opening trunk,  working steering system', 8290, 52.66, 87.77, 'SampleImages/vintage_car.png', NULL),
	('S18_4600', '1940s Ford truck', NULL, 'Trucks and Buses', '1:18', 'Motor City Art Classics', 'This 1940s Ford Pick-Up truck is re-created in 1:18 scale of original 1940s Ford truck. This antique style metal 1940s Ford Flatbed truck is all hand-assembled. This collectible 1940\'s Pick-Up truck is painted in classic dark green color, and features rotating wheels.', 3128, 84.76, 121.08, 'SampleImages/truck.jpg', NULL),
	('S18_4668', '1939 Cadillac Limousine', NULL, 'Vintage Cars', '1:18', 'Studio M Art Models', 'Features completely detailed interior including Velvet flocked drapes,deluxe wood grain floor, and a wood grain casket with seperate chrome handles', 6645, 23.14, 50.31, 'SampleImages/vintage_car.png', NULL),
	('S18_4721', '1957 Corvette Convertible', NULL, 'Classic Cars', '1:18', 'Classic Metal Creations', '1957 die cast Corvette Convertible in Roman Red with white sides and whitewall tires. 1:18 scale quality die-cast with detailed engine and underbvody. Now you can own The Classic Corvette.', 1249, 69.93, 148.8, 'SampleImages/classic_car.png', NULL),
	('S18_4933', '1957 Ford Thunderbird', NULL, 'Classic Cars', '1:18', 'Studio M Art Models', 'This 1:18 scale precision die-cast replica, with its optional porthole hardtop and factory baked-enamel Thunderbird Bronze finish, is a 100% accurate rendition of this American classic.', 3209, 34.21, 71.27, 'SampleImages/classic_car.png', NULL),
	('S24_1046', '1970 Chevy Chevelle SS 454', NULL, 'Classic Cars', '1:24', 'Unimax Art Galleries', 'This model features rotating wheels, working streering system and opening doors. All parts are particularly delicate due to their precise scale and require special care and attention. It should not be picked up by the doors, roof, hood or trunk.', 1005, 49.24, 73.49, 'SampleImages/classic_car.png', NULL),
	('S24_1444', '1970 Dodge Coronet', '', 'Classic Cars', '1:11', 'Highway 66 Mini Classics', '1:24 scale die-cast about 18" long doors open, hood opens and rubber wheels', 4074, 32.37, 57.8, 'SampleImages/classic_car.png', ''),
	('S24_1578', '1997 BMW R 1100 S', NULL, 'Motorcycles', '1:24', 'Autoart Studio Design', 'Detailed scale replica with working suspension and constructed from over 70 parts', 7003, 60.86, 112.7, 'SampleImages/motorcycle.jpg', NULL),
	('S24_1628', '1966 Shelby Cobra 427 S/C', NULL, 'Classic Cars', '1:24', 'Carousel DieCast Legends', 'This diecast model of the 1966 Shelby Cobra 427 S/C includes many authentic details and operating parts. The 1:24 scale model of this iconic lighweight sports car from the 1960s comes in silver and it\'s own display case.', 8197, 29.18, 50.31, 'SampleImages/classic_car.png', NULL),
	('S24_1785', '1928 British Royal Navy Airplane', NULL, 'Planes', '1:24', 'Classic Metal Creations', 'Official logos and insignias', 3627, 66.74, 109.42, 'SampleImages/motorcycle.jpg', NULL),
	('S24_1937', '1939 Chevrolet Deluxe Coupe', NULL, 'Vintage Cars', '1:24', 'Motor City Art Classics', 'This 1:24 scale die-cast replica of the 1939 Chevrolet Deluxe Coupe has the same classy look as the original. Features opening trunk, hood and doors and a showroom quality baked enamel finish.', 7332, 22.57, 33.19, 'SampleImages/vintage_car.png', NULL),
	('S24_2000', '1960 BSA Gold Star DBD34', NULL, 'Motorcycles', '1:24', 'Highway 66 Mini Classics', 'Detailed scale replica with working suspension and constructed from over 70 parts', 15, 37.32, 76.17, 'SampleImages/motorcycle.jpg', NULL),
	('S24_2011', '18th century schooner', NULL, 'Ships', '1:24', 'Carousel DieCast Legends', 'All wood with canvas sails. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with 4 masts, all square-rigged.', 1898, 82.34, 122.89, 'SampleImages/motorcycle.jpg', NULL),
	('S24_2022', '1938 Cadillac V-16 Presidential Limousine', NULL, 'Vintage Cars', '1:24', 'Classic Metal Creations', 'This 1:24 scale precision die cast replica of the 1938 Cadillac V-16 Presidential Limousine has all the details of the original, from the flags on the front to an opening back seat compartment complete with telephone and rifle. Features factory baked-enamel black finish, hood goddess ornament, working jump seats.', 2847, 20.61, 44.8, 'SampleImages/vintage_car.png', NULL),
	('S24_2300', '1962 Volkswagen Microbus', NULL, 'Trucks and Buses', '1:24', 'Autoart Studio Design', 'This 1:18 scale die cast replica of the 1962 Microbus is loaded with features: A working steering system, opening front doors and tailgate, and famous two-tone factory baked enamel finish, are all topped of by the sliding, real fabric, sunroof.', 2327, 61.34, 127.79, 'SampleImages/truck.jpg', NULL),
	('S24_2360', '1982 Ducati 900 Monster', NULL, 'Motorcycles', '1:24', 'Highway 66 Mini Classics', 'Features two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand', 6840, 47.1, 69.26, 'SampleImages/motorcycle.jpg', NULL),
	('S24_2766', '1949 Jaguar XK 120', NULL, 'Classic Cars', '1:24', 'Classic Metal Creations', 'Precision-engineered from original Jaguar specification in perfect scale ratio. Features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 2350, 47.25, 90.87, 'SampleImages/classic_car.png', NULL),
	('S24_2840', '1958 Chevy Corvette Limited Edition', NULL, 'Classic Cars', '1:24', 'Carousel DieCast Legends', 'The operating parts of this 1958 Chevy Corvette Limited Edition are particularly delicate due to their precise scale and require special care and attention. Features rotating wheels, working streering, opening doors and trunk. Color dark green.', 2542, 15.91, 35.36, 'SampleImages/classic_car.png', NULL),
	('S24_2841', '1900s Vintage Bi-Plane', NULL, 'Planes', '1:24', 'Autoart Studio Design', 'Hand crafted diecast-like metal bi-plane is re-created in about 1:24 scale of antique pioneer airplane. All hand-assembled with many different parts. Hand-painted in classic yellow and features correct markings of original airplane.', 5942, 34.25, 68.51, 'SampleImages/motorcycle.jpg', NULL),
	('S24_2887', '1952 Citroen-15CV', NULL, 'Classic Cars', '1:24', 'Exoto Designs', 'Precision crafted hand-assembled 1:18 scale reproduction of the 1952 15CV, with its independent spring suspension, working steering system, opening doors and hood, detailed engine and instrument panel, all topped of with a factory fresh baked enamel finish.', 1452, 72.82, 117.44, 'SampleImages/classic_car.png', NULL),
	('S24_2972', '1982 Lamborghini Diablo', NULL, 'Classic Cars', '1:24', 'Second Gear Diecast', 'This replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 7723, 16.24, 37.76, 'SampleImages/classic_car.png', NULL),
	('S24_3151', '1912 Ford Model T Delivery Wagon', NULL, 'Vintage Cars', '1:24', 'Min Lin Diecast', 'This model features chrome trim and grille, opening hood, opening doors, opening trunk, detailed engine, working steering system. Color white.', 9173, 46.91, 88.51, 'SampleImages/vintage_car.png', NULL),
	('S24_3191', '1969 Chevrolet Camaro Z28', NULL, 'Classic Cars', '1:24', 'Exoto Designs', '1969 Z/28 Chevy Camaro 1:24 scale replica. The operating parts of this limited edition 1:24 scale diecast model car 1969 Chevy Camaro Z28- hood, trunk, wheels, streering, suspension and doors- are particularly delicate due to their precise scale and require special care and attention.', 4695, 50.51, 85.61, 'SampleImages/classic_car.png', NULL),
	('S24_3371', '1971 Alpine Renault 1600s', NULL, 'Classic Cars', '1:24', 'Welly Diecast Productions', 'This 1971 Alpine Renault 1600s replica Features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 7995, 38.58, 61.23, 'SampleImages/classic_car.png', NULL),
	('S24_3420', '1937 Horch 930V Limousine', NULL, 'Vintage Cars', '1:24', 'Autoart Studio Design', 'Features opening hood, opening doors, opening trunk, wide white wall tires, front door arm rests, working steering system', 2902, 26.3, 65.75, 'SampleImages/vintage_car.png', NULL),
	('S24_3432', '2002 Chevy Corvette', NULL, 'Classic Cars', '1:24', 'Gearbox Collectibles', 'The operating parts of this limited edition Diecast 2002 Chevy Corvette 50th Anniversary Pace car Limited Edition are particularly delicate due to their precise scale and require special care and attention. Features rotating wheels, poseable streering, opening doors and trunk.', 9446, 62.11, 107.08, 'SampleImages/classic_car.png', NULL),
	('S24_3816', '1940 Ford Delivery Sedan', NULL, 'Vintage Cars', '1:24', 'Carousel DieCast Legends', 'Chrome Trim, Chrome Grille, Opening Hood, Opening Doors, Opening Trunk, Detailed Engine, Working Steering System. Color black.', 6621, 48.64, 83.86, 'SampleImages/vintage_car.png', NULL),
	('S24_3856', '1956 Porsche 356A Coupe', NULL, 'Classic Cars', '1:18', 'Classic Metal Creations', 'Features include: Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 6600, 98.3, 140.43, 'SampleImages/classic_car.png', NULL),
	('S24_3949', 'Corsair F4U ( Bird Cage)', NULL, 'Planes', '1:24', 'Second Gear Diecast', 'Has retractable wheels and comes with a stand. Official logos and insignias.', 6812, 29.34, 68.24, 'SampleImages/motorcycle.jpg', NULL),
	('S24_3969', '1936 Mercedes Benz 500k Roadster', NULL, 'Vintage Cars', '1:24', 'Red Start Diecast', 'This model features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system and rubber wheels. Color black.', 2081, 21.75, 41.03, 'SampleImages/vintage_car.png', NULL),
	('S24_4048', '1992 Porsche Cayenne Turbo Silver', NULL, 'Classic Cars', '1:24', 'Exoto Designs', 'This replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 6582, 69.78, 118.28, 'SampleImages/classic_car.png', NULL),
	('S24_4258', '1936 Chrysler Airflow', NULL, 'Vintage Cars', '1:24', 'Second Gear Diecast', 'Features opening trunk,  working steering system. Color dark green.', 4710, 57.46, 97.39, 'SampleImages/vintage_car.png', NULL),
	('S24_4278', '1900s Vintage Tri-Plane', NULL, 'Planes', '1:24', 'Unimax Art Galleries', 'Hand crafted diecast-like metal Triplane is Re-created in about 1:24 scale of antique pioneer airplane. This antique style metal triplane is all hand-assembled with many different parts.', 2756, 36.23, 72.45, 'SampleImages/motorcycle.jpg', NULL),
	('S24_4620', '1961 Chevrolet Impala', NULL, 'Classic Cars', '1:18', 'Classic Metal Creations', 'This 1:18 scale precision die-cast reproduction of the 1961 Chevrolet Impala has all the features-doors, hood and trunk that open; detailed 409 cubic-inch engine; chrome dashboard and stick shift, two-tone interior; working steering system; all topped of with a factory baked-enamel finish.', 7869, 32.33, 80.84, 'SampleImages/classic_car.png', NULL),
	('S32_1268', '1980â€™s GM Manhattan Express', NULL, 'Trucks and Buses', '1:32', 'Motor City Art Classics', 'This 1980â€™s era new look Manhattan express is still active, running from the Bronx to mid-town Manhattan. Has 35 opeining windows and working lights. Needs a battery.', 5099, 53.93, 96.31, 'SampleImages/truck.jpg', NULL),
	('S32_1374', '1997 BMW F650 ST', NULL, 'Motorcycles', '1:32', 'Exoto Designs', 'Features official die-struck logos and baked enamel finish. Comes with stand.', 178, 66.92, 99.89, 'SampleImages/motorcycle.jpg', NULL),
	('S32_2206', '1982 Ducati 996 R', NULL, 'Motorcycles', '1:32', 'Gearbox Collectibles', 'Features rotating wheels , working kick stand. Comes with stand.', 9241, 24.14, 40.23, 'SampleImages/motorcycle.jpg', NULL),
	('S32_2509', '1954 Greyhound Scenicruiser', NULL, 'Trucks and Buses', '1:32', 'Classic Metal Creations', 'Model features bi-level seating, 50 windows, skylights & glare resistant glass, working steering system, original logos', 2874, 25.98, 54.11, 'SampleImages/truck.jpg', NULL),
	('S32_3207', '1950\'s Chicago Surface Lines Streetcar', NULL, 'Trains', '1:32', 'Gearbox Collectibles', 'This streetcar is a joy to see. It has 80 separate windows, electric wire guides, detailed interiors with seats, poles and drivers controls, rolling and turning wheel assemblies, plus authentic factory baked-enamel finishes (Green Hornet for Chicago and Cream and Crimson for Boston).', 8601, 26.72, 62.14, 'SampleImages/motorcycle.jpg', NULL),
	('S32_3522', '1996 Peterbilt 379 Stake Bed with Outrigger', NULL, 'Trucks and Buses', '1:32', 'Red Start Diecast', 'This model features, opening doors, detailed engine, working steering, tinted windows, detailed interior, die-struck logos, removable stakes operating outriggers, detachable second trailer, functioning 360-degree self loader, precision molded resin trailer and trim, baked enamel finish on cab', 814, 33.61, 64.64, 'SampleImages/truck.jpg', NULL),
	('S32_4289', '1928 Ford Phaeton Deluxe', NULL, 'Vintage Cars', '1:32', 'Highway 66 Mini Classics', 'This model features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system', 136, 33.02, 68.79, 'SampleImages/vintage_car.png', NULL),
	('S32_4485', '1974 Ducati 350 Mk3 Desmo', NULL, 'Motorcycles', '1:32', 'Second Gear Diecast', 'This model features two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand', 3341, 56.13, 102.05, 'SampleImages/motorcycle.jpg', NULL),
	('S50_1341', '1930 Buick Marquette Phaeton', NULL, 'Vintage Cars', '1:50', 'Studio M Art Models', 'Features opening trunk,  working steering system', 7062, 27.06, 43.64, 'SampleImages/vintage_car.png', NULL),
	('S50_1392', 'Diamond T620 Semi-Skirted Tanker', NULL, 'Trucks and Buses', '1:50', 'Highway 66 Mini Classics', 'This limited edition model is licensed and perfectly scaled for Lionel Trains. The Diamond T620 has been produced in solid precision diecast and painted with a fire baked enamel finish. It comes with a removable tanker and is a perfect model to add authenticity to your static train or car layout or to just have on display.', 1016, 68.29, 115.75, 'SampleImages/truck.jpg', NULL),
	('S50_1514', '1962 City of Detroit Streetcar', NULL, 'Trains', '1:50', 'Classic Metal Creations', 'This streetcar is a joy to see. It has 99 separate windows, electric wire guides, detailed interiors with seats, poles and drivers controls, rolling and turning wheel assemblies, plus authentic factory baked-enamel finishes (Green Hornet for Chicago and Cream and Crimson for Boston).', 1645, 37.49, 58.58, 'SampleImages/motorcycle.jpg', NULL),
	('S50_4713', '2002 Yamaha YZR M1', NULL, 'Motorcycles', '1:50', 'Autoart Studio Design', 'Features rotating wheels , working kick stand. Comes with stand.', 600, 34.17, 81.36, 'SampleImages/motorcycle.jpg', NULL),
	('S700_1138', 'The Schooner Bluenose', NULL, 'Ships', '1:700', 'Autoart Studio Design', 'All wood with canvas sails. Measures 31 1/2 inches in Length, 22 inches High and 4 3/4 inches Wide. Many extras.\r\nThe schooner Bluenose was built in Nova Scotia in 1921 to fish the rough waters off the coast of Newfoundland. Because of the Bluenose racing prowess she became the pride of all Canadians. Still featured on stamps and the Canadian dime, the Bluenose was lost off Haiti in 1946.', 1897, 34, 66.67, 'SampleImages/motorcycle.jpg', NULL),
	('S700_1691', 'American Airlines: B767-300', NULL, 'Planes', '1:700', 'Min Lin Diecast', 'Exact replia with official logos and insignias and retractable wheels', 5841, 51.15, 91.34, 'SampleImages/motorcycle.jpg', NULL),
	('S700_1938', 'The Mayflower', NULL, 'Ships', '1:700', 'Studio M Art Models', 'Measures 31 1/2 inches Long x 25 1/2 inches High x 10 5/8 inches Wide\r\nAll wood with canvas sail. Extras include long boats, rigging, ladders, railing, anchors, side cannons, hand painted, etc.', 737, 43.3, 86.61, 'SampleImages/motorcycle.jpg', NULL),
	('S700_2047', 'HMS Bounty', NULL, 'Ships', '1:700', 'Unimax Art Galleries', 'Measures 30 inches Long x 27 1/2 inches High x 4 3/4 inches Wide. \r\nMany extras including rigging, long boats, pilot house, anchors, etc. Comes with three masts, all square-rigged.', 3501, 39.83, 90.52, 'SampleImages/motorcycle.jpg', NULL),
	('S700_2466', 'America West Airlines B757-200', NULL, 'Planes', '1:700', 'Motor City Art Classics', 'Official logos and insignias. Working steering system. Rotating jet engines', 9653, 68.8, 99.72, 'SampleImages/motorcycle.jpg', NULL),
	('S700_2610', 'The USS Constitution Ship', NULL, 'Ships', '1:700', 'Red Start Diecast', 'All wood with canvas sails. Measures 31 1/2" Length x 22 3/8" High x 8 1/4" Width. Extras include 4 boats on deck, sea sprite on bow, anchors, copper railing, pilot houses, etc.', 7083, 33.97, 72.28, 'SampleImages/motorcycle.jpg', NULL),
	('S700_2824', '1982 Camaro Z28', NULL, 'Classic Cars', '1:18', 'Carousel DieCast Legends', 'Features include opening and closing doors. Color: White. \r\nMeasures approximately 9 1/2" Long.', 6934, 46.53, 101.15, 'SampleImages/classic_car.png', NULL),
	('S700_2834', 'ATA: B757-300', NULL, 'Planes', '1:700', 'Highway 66 Mini Classics', 'Exact replia with official logos and insignias and retractable wheels', 7106, 59.33, 118.65, 'SampleImages/motorcycle.jpg', NULL),
	('S700_3167', 'F/A 18 Hornet 1/72', NULL, 'Planes', '1:72', 'Motor City Art Classics', '10" Wingspan with retractable landing gears.Comes with pilot', 551, 54.4, 80, 'SampleImages/motorcycle.jpg', NULL),
	('S700_3505', 'The Titanic', NULL, 'Ships', '1:700', 'Carousel DieCast Legends', 'Completed model measures 19 1/2 inches long, 9 inches high, 3inches wide and is in barn red/black. All wood and metal.', 1956, 51.09, 100.17, 'SampleImages/motorcycle.jpg', NULL),
	('S700_3962', 'The Queen Mary', NULL, 'Ships', '1:700', 'Welly Diecast Productions', 'Exact replica. Wood and Metal. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with three masts, all square-rigged.', 5088, 53.63, 99.31, 'SampleImages/motorcycle.jpg', NULL),
	('S700_4002', 'American Airlines: MD-11S', NULL, 'Planes', '1:700', 'Second Gear Diecast', 'Polished finish. Exact replia with official logos and insignias and retractable wheels', 8820, 36.27, 74.03, 'SampleImages/motorcycle.jpg', NULL),
	('S72_1253', 'Boeing X-32A JSF', NULL, 'Planes', '1:72', 'Motor City Art Classics', '10" Wingspan with retractable landing gears.Comes with pilot', 4857, 32.77, 49.66, 'SampleImages/motorcycle.jpg', NULL),
	('S72_3212', 'Pont Yacht', NULL, 'Ships', '1:72', 'Unimax Art Galleries', 'Measures 38 inches Long x 33 3/4 inches High. Includes a stand.\r\nMany extras including rigging, long boats, pilot house, anchors, etc. Comes with 2 masts, all square-rigged', 414, 33.3, 54.6, 'SampleImages/motorcycle.jpg', NULL);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;

-- Dump della struttura di vista sampledb.vorderdetails
-- Creazione di una tabella temporanea per risolvere gli errori di dipendenza della vista
CREATE TABLE `vorderdetails` (
	`orderNumber` INT(11) NOT NULL,
	`productCode` VARCHAR(1) NOT NULL COLLATE 'latin1_swedish_ci',
	`quantityOrdered` INT(11) NOT NULL,
	`priceEach` DOUBLE NOT NULL,
	`orderLineNumber` SMALLINT(6) NOT NULL,
	`productName` VARCHAR(1) NULL COLLATE 'latin1_swedish_ci',
	`productLine` VARCHAR(1) NULL COLLATE 'latin1_swedish_ci',
	`productScale` VARCHAR(1) NULL COLLATE 'latin1_swedish_ci',
	`productVendor` VARCHAR(1) NULL COLLATE 'latin1_swedish_ci',
	`productDescription` TEXT NULL COLLATE 'latin1_swedish_ci',
	`orderLineTotal` DOUBLE(19,2) NOT NULL
);

-- Dump della struttura di vista sampledb.vorders
-- Creazione di una tabella temporanea per risolvere gli errori di dipendenza della vista
CREATE TABLE `vorders` (
	`orderNumber` INT(11) NOT NULL,
	`orderDate` DATETIME NOT NULL,
	`orderDate_eu` VARCHAR(1) NULL COLLATE 'utf8mb4_general_ci',
	`requiredDate` DATETIME NOT NULL,
	`shippedDate` DATETIME NULL,
	`status` VARCHAR(1) NOT NULL COLLATE 'latin1_swedish_ci',
	`comments` TEXT NULL COLLATE 'latin1_swedish_ci',
	`customerNumber` INT(11) NOT NULL,
	`color` VARCHAR(1) NULL COMMENT 'Ciolor hex format, eg. FFFFFF (white)' COLLATE 'latin1_swedish_ci',
	`customerName` VARCHAR(1) NOT NULL COLLATE 'latin1_swedish_ci',
	`contactLastName` VARCHAR(1) NOT NULL COLLATE 'latin1_swedish_ci',
	`contactFirstName` VARCHAR(1) NOT NULL COLLATE 'latin1_swedish_ci',
	`phone` VARCHAR(1) NOT NULL COLLATE 'latin1_swedish_ci',
	`addressLine1` VARCHAR(1) NOT NULL COLLATE 'latin1_swedish_ci',
	`addressLine2` VARCHAR(1) NULL COLLATE 'latin1_swedish_ci',
	`city` VARCHAR(1) NOT NULL COLLATE 'latin1_swedish_ci',
	`state` VARCHAR(1) NULL COLLATE 'latin1_swedish_ci',
	`postalCode` VARCHAR(1) NULL COLLATE 'latin1_swedish_ci',
	`country` VARCHAR(1) NOT NULL COLLATE 'latin1_swedish_ci',
	`salesRepEmployeeNumber` INT(11) NULL,
	`creditLimit` DOUBLE NULL,
	`orderTotal` DOUBLE(19,2) NULL,
	`itemsCount` BIGINT(21) NOT NULL,
	`pagesCount` DECIMAL(21,0) NULL
);

-- Rimozione temporanea di tabella e creazione della struttura finale della vista
DROP TABLE IF EXISTS `vorderdetails`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `vorderdetails` AS SELECT 
        `det`.`orderNumber` AS `orderNumber`,
        `det`.`productCode` AS `productCode`,
        `det`.`quantityOrdered` AS `quantityOrdered`,
        `det`.`priceEach` AS `priceEach`,
        `det`.`orderLineNumber` AS `orderLineNumber`,
        `prod`.`productName` AS `productName`,
        `prod`.`productLine` AS `productLine`,
        `prod`.`productScale` AS `productScale`,
        `prod`.`productVendor` AS `productVendor`,
        `prod`.`productDescription` AS `productDescription`,
        ROUND(`det`.`quantityOrdered` * `det`.`priceEach`,
                2) AS `orderLineTotal`
    FROM
        (`sampledb`.`orderdetails` `det`
        LEFT JOIN `sampledb`.`products` `prod` ON (`prod`.`productCode` = `det`.`productCode`))
    ORDER BY `det`.`orderNumber` ASC, `det`.`orderLineNumber` ASC 
;

-- Rimozione temporanea di tabella e creazione della struttura finale della vista
DROP TABLE IF EXISTS `vorders`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `vorders` AS SELECT 
        `ord`.`orderNumber` AS `orderNumber`,
        `ord`.`orderDate` AS `orderDate`,
        DATE_FORMAT(`ord`.`orderDate`, '%d/%m/%Y') AS `orderDate_eu`,
        `ord`.`requiredDate` AS `requiredDate`,
        `ord`.`shippedDate` AS `shippedDate`,
        `ord`.`status` AS `status`,
        `ord`.`comments` AS `comments`,
        `ord`.`customerNumber` AS `customerNumber`,
        `ord`.`color` AS `color`,
        `cust`.`customerName` AS `customerName`,
        `cust`.`contactLastName` AS `contactLastName`,
        `cust`.`contactFirstName` AS `contactFirstName`,
        `cust`.`phone` AS `phone`,
        `cust`.`addressLine1` AS `addressLine1`,
        `cust`.`addressLine2` AS `addressLine2`,
        `cust`.`city` AS `city`,
        `cust`.`state` AS `state`,
        `cust`.`postalCode` AS `postalCode`,
        `cust`.`country` AS `country`,
        `cust`.`salesRepEmployeeNumber` AS `salesRepEmployeeNumber`,
        `cust`.`creditLimit` AS `creditLimit`,
        ROUND(SUM(`det`.`quantityOrdered` * `det`.`priceEach`),
                2) AS `orderTotal`,
        COUNT(`det`.`orderLineNumber`) AS `itemsCount`,
        CEILING(COUNT(`det`.`orderLineNumber`) / 11) AS `pagesCount`
    FROM
        ((`sampledb`.`orders` `ord`
        JOIN `sampledb`.`orderdetails` `det` ON (`ord`.`orderNumber` = `det`.`orderNumber`))
        JOIN `sampledb`.`customers` `cust` ON (`ord`.`customerNumber` = `cust`.`customerNumber`))
    GROUP BY 
		`ord`.`orderNumber` , `ord`.`orderDate` , `ord`.`requiredDate` , `ord`.`shippedDate` , `ord`.`status` , `ord`.`comments` , `ord`.`customerNumber` , `ord`.`color`,
		`cust`.`customerName`, `cust`.`contactLastName`, `cust`.`contactFirstName`, `cust`.`phone`, `cust`.`addressLine1`, `cust`.`addressLine2`,  `cust`.`city`, `cust`.`state`,
        `cust`.`postalCode`, `cust`.`country`, `cust`.`salesRepEmployeeNumber`, `cust`.`creditLimit`
    ORDER BY `ord`.`orderNumber` , `det`.`orderLineNumber` 
;

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
